/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Qt Software Information (qt-info@nokia.com)
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at qt-sales@nokia.com.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef WBDOWNLOADMANAGER_H
#define WBDOWNLOADMANAGER_H

#include "ui_downloads.h"
#include "ui_downloaditem.h"

#include <QtNetwork>
#include <QtCore>

class WBDownloadItem : public QWidget, public Ui_DownloadItem
{
    Q_OBJECT

    signals:
        void statusChanged();

    public:
        WBDownloadItem(QNetworkReply *reply = 0, bool requestFileName = false, QWidget *parent = 0, QString customDownloadPath = QString());
        bool downloading() const;
        bool downloadedSuccessfully() const;

        QUrl m_url;

        QFile m_output;
        QNetworkReply *m_reply;

    private slots:
        void stop();
        void tryAgain();
        void open();

        void downloadReadyRead();
        void error(QNetworkReply::NetworkError code);
        void downloadProgress(qint64 bytesReceived, qint64 bytesTotal);
        void metaDataChanged();
        void finished();

    private:
        void getFileName();
        void init();
        void updateInfoLabel();
        QString dataString(int size) const;

        QString saveFileName(const QString &directory) const;

        bool mRequestFileName;
        qint64 mBytesReceived;
        QTime mDownloadTime;
        QString mCustomDownloadPath;

};

class UBAutoSaver;
class WBDownloadModel;


class WBDownloadManager : public QDialog, public Ui_DownloadDialog
{
        Q_OBJECT
        Q_PROPERTY(RemovePolicy removePolicy READ removePolicy WRITE setRemovePolicy)
        Q_ENUMS(RemovePolicy)

    public:
        enum RemovePolicy {
            Never,
            Exit,
            SuccessFullDownload
        };

        WBDownloadManager(QWidget *parent = 0);
        ~WBDownloadManager();
        int activeDownloads() const;

        RemovePolicy removePolicy() const;
        void setRemovePolicy(RemovePolicy policy);

    public slots:
        void download(const QNetworkRequest &request, bool requestFileName = false);
        inline void download(const QUrl &url, bool requestFileName = false)
            { download(QNetworkRequest(url), requestFileName); }
        void handleUnsupportedContent(QNetworkReply *reply, bool requestFileName = false, QString customDownloadPath = QString());
        void cleanup();

    private slots:
        void save() const;
        void updateRow();
        void processDownloadedContent(QNetworkReply *reply, bool requestFileName, QString customDownloadPath = QString());

    private:
        void addItem(WBDownloadItem *item);
        void updateItemCount();
        void load();

        UBAutoSaver *mAutoSaver;
        WBDownloadModel *mModel;
        QNetworkAccessManager *mManager;
        QFileIconProvider *mIconProvider;
        QList<WBDownloadItem*> mDownloads;
        RemovePolicy m_RemovePolicy;
        friend class WBDownloadModel;

        bool mIsLoading;
};

class WBDownloadModel : public QAbstractListModel
{
    friend class WBDownloadManager;
    Q_OBJECT

    public:
        WBDownloadModel(WBDownloadManager *downloadManager, QObject *parent = 0);
        QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const;
        int rowCount(const QModelIndex &parent = QModelIndex()) const;
        bool removeRows(int row, int count, const QModelIndex &parent = QModelIndex());

    private:
        WBDownloadManager *mDownloadManager;

};

#endif // WBDOWNLOADMANAGER_H

