/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef UBCOREGRAPHICSSCENE_H_
#define UBCOREGRAPHICSSCENE_H_

#include <QtGui>

class UBCoreGraphicsScene : public QGraphicsScene
{
    public:
        UBCoreGraphicsScene(QObject * parent = 0);
        virtual ~UBCoreGraphicsScene();

        virtual void addItem(QGraphicsItem* item);

        virtual void removeItem(QGraphicsItem* item, bool forceDelete = false);

        virtual bool deleteItem(QGraphicsItem* item);

        void removeItemFromDeletion(QGraphicsItem* item);
        void addItemToDeletion(QGraphicsItem *item);

    private:
        QSet<QGraphicsItem*> mItemsToDelete;
};

#endif /* UBCOREGRAPHICSSCENE_H_ */
